/*****************************************************************************
 * file:        $RCSfile: bintimestamp.c,v $ $Revision: 1.1 $
 * module:      timestamp
 * authors:     jeremyd
 * last mod:    $Author: jeremyd $ at $Date: 2005/10/28 20:26:38 $
 * 
 * created:     Fri Oct 28 13:26:38 PDT 2005
 * 
 *****************************************************************************/

#include <string.h>
#include <math.h>
#include "postgres.h"

#include "fmgr.h"
#include "libpq/pqformat.h"
#include "utils/builtins.h"
#include "funcapi.h"
#include "utils/timestamp.h"

#ifndef JROUND
#	define JROUND(x) (x)
#endif

Datum timestamp_get_bin_size(PG_FUNCTION_ARGS);
Datum timestamp_bin(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(timestamp_get_bin_size);
Datum
timestamp_get_bin_size(PG_FUNCTION_ARGS)
{
	Timestamp start = PG_GETARG_TIMESTAMP(0);
	Timestamp stop = PG_GETARG_TIMESTAMP(1);
	int32 nbuckets = PG_GETARG_INT32(2);
	Interval * retval = (Interval *)palloc (sizeof(Interval));

	if (!retval)
	{
		ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("insufficient memory for Interval allocation")));
		PG_RETURN_NULL();
	}

	memset (retval, 0, sizeof(Interval));

	retval->time = JROUND ((stop - start) / nbuckets);

	PG_RETURN_INTERVAL_P(retval);
}

PG_FUNCTION_INFO_V1(timestamp_bin);
Datum
timestamp_bin(PG_FUNCTION_ARGS)
{
	/*Timestamp op = PG_GETARG_TIMESTAMP(0);*/
	Timestamp start = PG_GETARG_TIMESTAMP(1);
	/*Timestamp stop = PG_GETARG_TIMESTAMP(2);*/
	Timestamp binsz;
	/*int32 nbuckets = PG_GETARG_INT32(3)*/;

	binsz = (PG_GETARG_TIMESTAMP(2) - start) / PG_GETARG_INT32(3);

	PG_RETURN_TIMESTAMP(JROUND((int)((PG_GETARG_TIMESTAMP(0) - start) / binsz) * binsz + start));
}
